/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessor2;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MClientInfo;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MProcess;
import org.compiere.model.MSchedule;
import org.compiere.model.MSchedulerLog;
import org.compiere.model.MSchedulerPara;
import org.compiere.model.MSchedulerRecipient;
import org.compiere.model.MTable;
import org.compiere.model.MUserRoles;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Scheduler;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutablePOSupport;

public class MScheduler
extends X_AD_Scheduler
implements AdempiereProcessor,
AdempiereProcessor2,
ImmutablePOSupport {
    private static final long serialVersionUID = -2427229109274587547L;
    private MSchedulerPara[] m_parameter = null;
    private MSchedulerRecipient[] m_recipients = null;

    public static MScheduler[] getActive(Properties ctx) {
        List<MScheduler> list = new Query(ctx, "AD_Scheduler", null, null).setOnlyActiveRecords(true).list();
        MScheduler[] retValue = new MScheduler[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MScheduler(Properties ctx, String AD_Scheduler_UU, String trxName) {
        super(ctx, AD_Scheduler_UU, trxName);
        if (Util.isEmpty(AD_Scheduler_UU)) {
            this.setInitialDefaults();
        }
    }

    public MScheduler(Properties ctx, int AD_Scheduler_ID, String trxName) {
        super(ctx, AD_Scheduler_ID, trxName);
        if (AD_Scheduler_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setKeepLogDays(7);
    }

    public MScheduler(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MScheduler(MScheduler copy) {
        this(Env.getCtx(), copy);
    }

    public MScheduler(Properties ctx, MScheduler copy) {
        this(ctx, copy, null);
    }

    public MScheduler(Properties ctx, MScheduler copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_parameter = copy.m_parameter != null ? (MSchedulerPara[])Arrays.stream(copy.m_parameter).map(e -> new MSchedulerPara(ctx, (MSchedulerPara)e, trxName)).toArray(MSchedulerPara[]::new) : null;
        this.m_recipients = copy.m_recipients != null ? (MSchedulerRecipient[])Arrays.stream(copy.m_recipients).map(e -> new MSchedulerRecipient(ctx, (MSchedulerRecipient)e, trxName)).toArray(MSchedulerRecipient[]::new) : null;
    }

    @Override
    public String getServerID() {
        if (this.get_ID() == 0 && this.get_IDOld() > 0) {
            return "Scheduler" + this.get_IDOld();
        }
        return "Scheduler" + this.get_ID();
    }

    @Override
    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName(), new String[0]);
        }
        return this.getDateNextRun();
    }

    @Override
    public AdempiereProcessorLog[] getLogs() {
        List<AdempiereProcessorLog> list = new Query(this.getCtx(), "AD_SchedulerLog", "AD_Scheduler_ID=?", this.get_TrxName()).setParameters(this.getAD_Scheduler_ID()).setOrderBy("Created DESC").list();
        AdempiereProcessorLog[] retValue = new MSchedulerLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE FROM AD_SchedulerLog WHERE AD_Scheduler_ID=" + this.getAD_Scheduler_ID() + " AND (Created+" + this.getKeepLogDays() + ") < getDate()";
        int no = DB.executeUpdateEx(sql, this.get_TrxName());
        return no;
    }

    public MProcess getProcess() {
        return MProcess.getCopy(this.getCtx(), this.getAD_Process_ID(), null);
    }

    public MSchedulerPara[] getParameters(boolean reload) {
        if (!reload && this.m_parameter != null) {
            return this.m_parameter;
        }
        List<MSchedulerPara> list = new Query(this.getCtx(), "AD_Scheduler_Para", "AD_Scheduler_ID=?", this.get_TrxName()).setParameters(this.getAD_Scheduler_ID()).setOnlyActiveRecords(true).list();
        if (list.size() > 0 && this.is_Immutable()) {
            list.stream().forEach(e -> {
                MSchedulerPara mSchedulerPara = e.markImmutable();
            });
        }
        this.m_parameter = new MSchedulerPara[list.size()];
        list.toArray(this.m_parameter);
        return this.m_parameter;
    }

    public MSchedulerRecipient[] getRecipients(boolean reload) {
        if (!reload && this.m_recipients != null) {
            return this.m_recipients;
        }
        List<MSchedulerRecipient> list = new Query(this.getCtx(), "AD_SchedulerRecipient", "AD_Scheduler_ID=?", this.get_TrxName()).setParameters(this.getAD_Scheduler_ID()).setOnlyActiveRecords(true).list();
        if (list.size() > 0 && this.is_Immutable()) {
            list.stream().forEach(e -> {
                MSchedulerRecipient mSchedulerRecipient = e.markImmutable();
            });
        }
        this.m_recipients = new MSchedulerRecipient[list.size()];
        list.toArray(this.m_recipients);
        return this.m_recipients;
    }

    public Integer[] getRecipientAD_User_IDs() {
        return this.getRecipientAD_User_IDs(false);
    }

    public Integer[] getRecipientAD_User_IDs(boolean excludeUploadRecipient) {
        TreeSet<Integer> list = new TreeSet<Integer>();
        MSchedulerRecipient[] recipients = this.getRecipients(false);
        int i2 = 0;
        while (i2 < recipients.length) {
            MSchedulerRecipient recipient = recipients[i2];
            if (recipient.isActive()) {
                if (!(recipient.getAD_User_ID() == 0 || excludeUploadRecipient && recipient.isUpload())) {
                    list.add(recipient.getAD_User_ID());
                }
                if (recipient.getAD_Role_ID() != 0) {
                    MUserRoles[] urs = MUserRoles.getOfRole(this.getCtx(), recipient.getAD_Role_ID());
                    int j = 0;
                    while (j < urs.length) {
                        MUserRoles ur = urs[j];
                        if (ur.isActive() && !list.contains(ur.getAD_User_ID())) {
                            list.add(ur.getAD_User_ID());
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        return list.toArray(new Integer[list.size()]);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Table_ID() > 0) {
            int colid = new Query(this.getCtx(), "AD_Column", "AD_Table_ID=? AND AD_Reference_ID=? AND AD_Process_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getAD_Table_ID(), 28, this.getAD_Process_ID()).firstId();
            if (colid <= 0) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "TableMustHaveProcessButton"));
                return false;
            }
        } else {
            this.setRecord_ID(-1);
        }
        if (this.getRecord_ID() != 0) {
            if (this.getAD_Table_ID() <= 0) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "MustFillTable"));
                return false;
            }
            MTable table2 = MTable.get(this.getCtx(), this.getAD_Table_ID());
            PO po = table2.getPO(this.getRecord_ID(), this.get_TrxName());
            if (po == null || po.get_ID() <= 0 || po.getAD_Client_ID() != this.getAD_Client_ID()) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "NoRecordID"));
                return false;
            }
        }
        if (newRecord || this.is_ValueChanged("AD_Schedule_ID")) {
            long nextWork;
            String timeZoneId = null;
            if (this.getAD_Client_ID() == 0 && this.getAD_Org_ID() == 0 || this.getAD_Org_ID() > 0) {
                MOrgInfo orgInfo = MOrgInfo.get(this.getAD_Org_ID());
                timeZoneId = orgInfo.getTimeZone();
            }
            if (Util.isEmpty(timeZoneId, true)) {
                MClientInfo clientInfo = MClientInfo.get(this.getCtx(), this.getAD_Client_ID());
                if (clientInfo == null) {
                    clientInfo = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
                }
                timeZoneId = clientInfo.getTimeZone();
            }
            if ((nextWork = MSchedule.getNextRunMS(System.currentTimeMillis(), this.getScheduleType(), this.getFrequencyType(), this.getFrequency(), this.getCronPattern(), timeZoneId)) > 0L) {
                this.setDateNextRun(new Timestamp(nextWork));
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MScheduler[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    @Override
    public String getFrequencyType() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getFrequencyType();
    }

    @Override
    public int getFrequency() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getFrequency();
    }

    @Override
    public boolean isIgnoreProcessingTime() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).isIgnoreProcessingTime();
    }

    @Override
    public String getScheduleType() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getScheduleType();
    }

    @Override
    public String getCronPattern() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getCronPattern();
    }

    @Override
    public MScheduler markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_parameter != null && this.m_parameter.length > 0) {
            Arrays.stream(this.m_parameter).forEach(e -> {
                MSchedulerPara mSchedulerPara = e.markImmutable();
            });
        }
        if (this.m_recipients != null && this.m_recipients.length > 0) {
            Arrays.stream(this.m_recipients).forEach(e -> {
                MSchedulerRecipient mSchedulerRecipient = e.markImmutable();
            });
        }
        return this;
    }

    public MSchedulerRecipient[] getUploadRecipients() {
        ArrayList<MSchedulerRecipient> list = new ArrayList<MSchedulerRecipient>();
        MSchedulerRecipient[] recipients = this.getRecipients(false);
        int i2 = 0;
        while (i2 < recipients.length) {
            MSchedulerRecipient recipient = recipients[i2];
            if (recipient.isActive() && recipient.getAD_User_ID() > 0 && recipient.isUpload() && recipient.getAD_AuthorizationAccount_ID() > 0) {
                list.add(recipient);
            }
            ++i2;
        }
        return list.toArray(new MSchedulerRecipient[0]);
    }
}

